//+------------------------------------------------------------------+
//|                                       NormalizeDouble_errors.mq4 |
//|                                        Copyright  2018, Amr Ali |
//|                             https://www.mql5.com/en/users/amrali |
//+------------------------------------------------------------------+
#property copyright "Copyright  2018, Amr Ali"
#property link      "https://www.mql5.com/en/users/amrali"
#property version   "4.0"
#property description "Script to demonstrate errors in the results of NormalizeDouble()."

#include <math_utils.mqh>

#define PRINT(A) Print(#A + " = ", (A))
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- NormalizeDouble(num, digits) gives unexpected results with many numbers (result maybe off by +/- 1 epsilon).

   Print("** NormalizeDouble(num, digits) Test:");
   PRINT( NormalizeDouble (1.005437, 5)    == 1.00544);
   PRINT( NormalizeDouble (1.215143, 5)    == 1.21514);
   PRINT( NormalizeDouble (1.768533, 5)    == 1.76853);
   PRINT( NormalizeDouble (1.30482,  5)    == 1.30482);
   PRINT( NormalizeDouble (1.62457,  5)    == 1.62457);
   PRINT( NormalizeDouble (1.80181,  5)    == 1.80181);

//--- Alternatively, use Round(num, digits) from 'math_utils' library to get the correct results.

   Print(" ");
   Print("** Round(num, digits) Test:");
   PRINT( Round(           1.005437, 5)    == 1.00544);
   PRINT( Round(           1.215143, 5)    == 1.21514);
   PRINT( Round(           1.768533, 5)    == 1.76853);
   PRINT( Round(           1.30482,  5)    == 1.30482);
   PRINT( Round(           1.62457,  5)    == 1.62457);
   PRINT( Round(           1.80181,  5)    == 1.80181);
  }
//+------------------------------------------------------------------+

// Output:
/*
 ** NormalizeDouble(num, digits) Test:
 NormalizeDouble(1.005437,5)==1.00544 = false
 NormalizeDouble(1.215143,5)==1.21514 = false
 NormalizeDouble(1.768533,5)==1.76853 = false
 NormalizeDouble(1.30482,5)==1.30482 = false
 NormalizeDouble(1.62457,5)==1.62457 = false
 NormalizeDouble(1.80181,5)==1.80181 = false

 ** Round(num, digits) Test:
 Round(1.005437,5)==1.00544 = true
 Round(1.215143,5)==1.21514 = true
 Round(1.768533,5)==1.76853 = true
 Round(1.30482,5)==1.30482 = true
 Round(1.62457,5)==1.62457 = true
 Round(1.80181,5)==1.80181 = true
*/
